<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link      https://cakephp.org CakePHP(tm) Project
 * @since     0.2.9
 * @license   https://opensource.org/licenses/mit-license.php MIT License
 */
namespace App\Controller;

use Cake\Http\Exception\NotFoundException;

/**
 * Static about us controller
 *
 * This controller will render views from Template/AboutUs/
 *
 */
class AboutUsController extends ContentController
{
  /**
   * Initialization hook method.
   *
   * Use this method to add common initialization code like loading components.
   *
   * e.g. `$this->loadComponent('Security');`
   *
   * @return void
   */
  public function initialize(): void
  {
    parent::initialize();
  }

  public function index()
  {
    // Loading content and basic processes to load the content has been implemented in the content
    // All we need to do is set the section to the correct slug for this controller
    // So lets just call the parent method
    $this->request = $this->request->withParam('section', 'about-us');
    parent::index();
  }

  public function subMenu()
  {
    // Loading content and basic processes to load the content has been implemented in the content
    // The section for this method is already set in the params of the request object
    // So lets just call the parent method
    parent::subsection();
  }

  public function details($id = null)
  {
    // Loading content and basic processes to load the content has been implemented in the content
    // The section for this method is already set in the params of the request object
    // So lets just call the parent method
    parent::details();
  }
}
