<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Home Controller
 *
 * @method \App\Model\Entity\Home[]|\Cake\Datasource\ResultSetInterface paginate($object = null, array $settings = [])
 */
class HomeController extends AppController
{
    public function initialize(): void
    {
        parent::initialize();

        $this->PageContents = $this->fetchTable('PageContents');
        $this->Banners = $this->fetchTable('Banners');
        $this->Galleries = $this->fetchTable('Galleries');
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        /** 
         * Homepage for the one pager site
         * Lets load the contents for the different sections
         * 
         * Contents are stored under different menus, in our order to load them correctly
         * Selects the different menus under the section and construct a an array with
         * with the contents saved with the menu as key
         */

        // Load only enabled menus
        $homeMenus = $this->PageContents->Menus->find()
            ->where(['status' => '1'])
            ->order(['home_order' => 'ASC'])
            ->all()
            ->toList();

        // Initialize the content array and populate the contents of each section
        // Filter by only contents that have been marked to show on the hompage
        $viewContents = [];

        // Populates sub menus that would be showing as points on the home
        // to redirect to the their home pages
        $viewSubsections = [];

        foreach ($homeMenus as $menu) {

            $contents = $this->PageContents->Contents->find()
                ->where(['status' => 1, 'show_on_home' => 1])
                ->contain(['ContentImages', 'PageContents'])
                ->matching('PageContents', function ($q) use ($menu) {
                    return $q->where(['PageContents.menu_id' => $menu->id]);
                })->toArray();

            if (!empty($contents)) {
                $viewContents[$menu->slug] = $contents;
            }

            $menuContents = $this->PageContents->Menus->find('all', [
                'contain' => [
                    'ParentMenus'
                ],
                'conditions' => [
                    'Menus.parent_menu_id' => $menu->id,
                    'Menus.status' => 1,
                    'Menus.show_on_home' => 1
                ]
            ])->toArray();

            if (!empty($menuContents)) {
                $viewSubsections[$menu->slug] = [
                    'section' => $menu,
                    'list' => $menuContents
                ];
            }

            // Load details on sub menus list
            $subMenuLists = $this->PageContents->Menus->find('all', [
                'conditions' => [
                    'status' => 0,
                    'parent_menu_id' => $menu->id
                ]
            ])->toArray();

            if (!empty($subMenuLists)) {
                $viewContents[$menu->slug] = $subMenuLists;
            }
        }

        // Load the banners. Banners are normally loaded at the top of the page.
        // So lets add it to the home section.
        // Append to any section if you want to show as well, could be carousel, etc....
        $banners = $this->Banners->find()
            ->where(['status' => 1])
            ->all()
            ->toArray();

        // Load the gallery records
        // Lets get all the pictures
        $galleryDetails = $this->Galleries->find()
            ->where(['status' => 1])
            ->all()
            ->toArray();

        // Initialize the content array and populate the contents of each section
        $viewAlbums = $this->Galleries->Albums->find()
            ->where(['Albums.status' => 1, 'Albums.show_on_home' => 1])
            ->contain(['Galleries'])
            ->toArray();

        /**
         * Perform additional task here before sending the values
         * to be rendered on the view
         */


        $this->set(compact(
            'viewContents',
            'banners',
            'galleryDetails',
            'homeMenus',
            'viewSubsections',
            'viewAlbums',
        ));
    }

}