<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Contact Entity
 *
 * @property int $id
 * @property string $address1
 * @property string $postal_address
 * @property string $street
 * @property string $phone1
 * @property string $phone2
 * @property string $phone3
 * @property string $email1
 * @property string $email2
 * @property string $email3
 * @property string|null $email_copy
 * @property string $longitude
 * @property string $latitude
 * @property string $google_map_address
 * @property string $address2
 * @property string $address3
 * @property string $facebook
 * @property string $twitter
 * @property string $instagram
 * @property string $linkedin
 * @property string $othersocialmedialink
 * @property string|null $whatsapp
 * @property string|null $youtube
 */
class Contact extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'address1' => true,
        'postal_address' => true,
        'street' => true,
        'phone1' => true,
        'phone2' => true,
        'phone3' => true,
        'email1' => true,
        'email2' => true,
        'email3' => true,
        'email_copy' => true,
        'longitude' => true,
        'latitude' => true,
        'google_map_address' => true,
        'address2' => true,
        'address3' => true,
        'facebook' => true,
        'twitter' => true,
        'instagram' => true,
        'linkedin' => true,
        'othersocialmedialink' => true,
        'whatsapp' => true,
        'youtube' => true,
    ];
}
