<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Product Entity
 *
 * @property int $id
 * @property string|null $name
 * @property string|null $description
 * @property int|null $quantity
 * @property int|null $viewed
 * @property \Cake\I18n\DateTime $featured_start_date
 * @property \Cake\I18n\DateTime $featured_end_date
 * @property int|null $status
 * @property string|null $price
 * @property int $featured
 * @property int $category_id
 * @property string $product_code
 * @property string $manufacture
 *
 * @property \App\Model\Entity\Category $category
 * @property \App\Model\Entity\PageProduct[] $page_products
 * @property \App\Model\Entity\ProductImage[] $product_images
 */
class Product extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'name' => true,
        'description' => true,
        'quantity' => true,
        'viewed' => true,
        'featured_start_date' => true,
        'featured_end_date' => true,
        'status' => true,
        'price' => true,
        'featured' => true,
        'category_id' => true,
        'product_code' => true,
        'manufacture' => true,
        'category' => true,
        'page_products' => true,
        'product_images' => true,
    ];
}
