<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Contacts Model
 *
 * @method \App\Model\Entity\Contact newEmptyEntity()
 * @method \App\Model\Entity\Contact newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Contact> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Contact get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Contact findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Contact patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Contact> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Contact|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Contact saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Contact>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Contact>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Contact>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Contact> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Contact>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Contact>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Contact>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Contact> deleteManyOrFail(iterable $entities, array $options = [])
 */
class ContactsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('contacts');
        $this->setDisplayField('title');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('address1')
            ->maxLength('address1', 255)
            ->requirePresence('address1', 'create')
            ->notEmptyString('address1');

        $validator
            ->scalar('postal_address')
            ->maxLength('postal_address', 50)
            ->requirePresence('postal_address', 'create')
            ->notEmptyString('postal_address');

        $validator
            ->scalar('street')
            ->maxLength('street', 255)
            ->requirePresence('street', 'create')
            ->notEmptyString('street');

        $validator
            ->scalar('phone1')
            ->maxLength('phone1', 50)
            ->requirePresence('phone1', 'create')
            ->notEmptyString('phone1');

        $validator
            ->scalar('phone2')
            ->maxLength('phone2', 50)
            ->requirePresence('phone2', 'create')
            ->notEmptyString('phone2');

        $validator
            ->scalar('phone3')
            ->maxLength('phone3', 50)
            ->requirePresence('phone3', 'create')
            ->notEmptyString('phone3');

        $validator
            ->scalar('email1')
            ->maxLength('email1', 255)
            ->requirePresence('email1', 'create')
            ->notEmptyString('email1');

        $validator
            ->scalar('email2')
            ->maxLength('email2', 255)
            ->requirePresence('email2', 'create')
            ->notEmptyString('email2');

        $validator
            ->scalar('email3')
            ->maxLength('email3', 255)
            ->requirePresence('email3', 'create')
            ->notEmptyString('email3');

        $validator
            ->scalar('email_copy')
            ->maxLength('email_copy', 500)
            ->allowEmptyString('email_copy');

        $validator
            ->scalar('longitude')
            ->maxLength('longitude', 50)
            ->requirePresence('longitude', 'create')
            ->notEmptyString('longitude');

        $validator
            ->scalar('latitude')
            ->maxLength('latitude', 50)
            ->requirePresence('latitude', 'create')
            ->notEmptyString('latitude');

        $validator
            ->scalar('google_map_address')
            ->maxLength('google_map_address', 16777215)
            ->requirePresence('google_map_address', 'create')
            ->notEmptyString('google_map_address');

        $validator
            ->scalar('address2')
            ->maxLength('address2', 255)
            ->requirePresence('address2', 'create')
            ->notEmptyString('address2');

        $validator
            ->scalar('address3')
            ->maxLength('address3', 255)
            ->requirePresence('address3', 'create')
            ->notEmptyString('address3');

        $validator
            ->scalar('facebook')
            ->maxLength('facebook', 255)
            ->requirePresence('facebook', 'create')
            ->notEmptyString('facebook');

        $validator
            ->scalar('twitter')
            ->maxLength('twitter', 255)
            ->requirePresence('twitter', 'create')
            ->notEmptyString('twitter');

        $validator
            ->scalar('instagram')
            ->maxLength('instagram', 255)
            ->requirePresence('instagram', 'create')
            ->notEmptyString('instagram');

        $validator
            ->scalar('linkedin')
            ->maxLength('linkedin', 255)
            ->requirePresence('linkedin', 'create')
            ->notEmptyString('linkedin');

        $validator
            ->scalar('othersocialmedialink')
            ->maxLength('othersocialmedialink', 255)
            ->requirePresence('othersocialmedialink', 'create')
            ->notEmptyString('othersocialmedialink');

        $validator
            ->scalar('whatsapp')
            ->maxLength('whatsapp', 255)
            ->allowEmptyString('whatsapp');

        $validator
            ->scalar('youtube')
            ->maxLength('youtube', 500)
            ->allowEmptyString('youtube');

        return $validator;
    }

    function getContacts()
    {
        return $this->find('All')->first();
    }
}
