<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * ContentImages Model
 *
 * @property \App\Model\Table\ContentsTable&\Cake\ORM\Association\BelongsTo $Contents
 *
 * @method \App\Model\Entity\ContentImage newEmptyEntity()
 * @method \App\Model\Entity\ContentImage newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\ContentImage> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\ContentImage get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\ContentImage findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\ContentImage patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\ContentImage> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\ContentImage|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\ContentImage saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\ContentImage>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ContentImage>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ContentImage>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ContentImage> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ContentImage>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ContentImage>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\ContentImage>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\ContentImage> deleteManyOrFail(iterable $entities, array $options = [])
 */
class ContentImagesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('content_images');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Contents', [
            'foreignKey' => 'content_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('image_path')
            ->maxLength('image_path', 255)
            ->allowEmptyString('image_path');

        $validator
            ->scalar('caption')
            ->maxLength('caption', 255)
            ->allowEmptyString('caption');

        $validator
            ->integer('content_id')
            ->notEmptyString('content_id');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['content_id'], 'Contents'), ['errorField' => 'content_id']);

        return $rules;
    }
}
