<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Library Model
 *
 * @property \App\Model\Table\CategoriesTable&\Cake\ORM\Association\BelongsTo $Categories
 *
 * @method \App\Model\Entity\Library newEmptyEntity()
 * @method \App\Model\Entity\Library newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\Library> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Library get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\Library findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\Library patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\Library> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\Library|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\Library saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\Library>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Library>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Library>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Library> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Library>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Library>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\Library>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\Library> deleteManyOrFail(iterable $entities, array $options = [])
 */
class LibraryTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('library');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->belongsTo('Categories', [
            'foreignKey' => 'category_id',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('name')
            ->maxLength('name', 255)
            ->requirePresence('name', 'create')
            ->notEmptyString('name');

        $validator
            ->scalar('doc_path')
            ->maxLength('doc_path', 255)
            ->requirePresence('doc_path', 'create')
            ->notEmptyString('doc_path');

        $validator
            ->integer('status')
            ->notEmptyString('status');

        $validator
            ->integer('category_id')
            ->allowEmptyString('category_id');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->existsIn(['category_id'], 'Categories'), ['errorField' => 'category_id']);

        return $rules;
    }
}
