<!-- Link AOS CSS -->
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

<!-- Link Swiper's CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />

<!-- Styles -->
<style>
  .swiper.bannerSwiper {
    height: 500px;
    width: 100%;
  }

  .banner-swiper-slide::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.2);
  }

  .swiper-slide img {
    display: block;
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: top;
  }

  .text-container {
    position: absolute;
    top: 50%;
    left: 20%;
    z-index: 2;
    color: white;
    transform: translateY(-50%);
  }

  .swiper-button-next,
  .swiper-button-prev {
    color: white;
    z-index: 10;
  }

  .swiper-pagination-bullet {
    background: white;
    z-index: 10;
  }

  /* Responsive styles */
  @media (max-width: 768px) {
    .swiper.bannerSwiper {
      height: 200px;
    }

    .swiper-button-next,
    .swiper-button-prev {
      display: none !important;
    }

    .text-container {
      left: 10%;
      font-size: 14px;
    }
  }
</style>

<!-- Swiper -->
<div class="swiper bannerSwiper">
  <div class="swiper-wrapper">
    <?php foreach ($banners as $banner): ?>
      <div class="swiper-slide position-relative banner-swiper-slide">
        <!-- Background Image -->
        <img src="<?= $this->Url->image($banner->image_path) ?>" alt="<?= h($banner->title) ?>" class="img-fluid w-100" />

        <!-- Dark Overlay -->
        <div class="position-absolute top-0 start-0 w-100 h-100 bg-dark opacity-50"></div>

        <!-- Text on Image -->
        <div class="position-absolute top-50 start-50 translate-middle text-white text-center z-3">
          <div class="col-lg-12">
            <div class="row">
              <div class="col-lg-11">
                <?php if (!empty($banner->title)): ?>
                  <h1 class="display-5 fw-bold mb-3 text-center" data-aos="fade-down" data-aos-duration="1000"><?= h($banner->title) ?></h1>
                  <p class="mb-lg-4" data-aos="fade-up" data-aos-duration="1000" data-aos-delay="200">
                    <?= h($banner->description) ?>
                  </p>
                  <a href="" class="btn btn-custom btn-lg" data-aos="zoom-in" data-aos-duration="1000" data-aos-delay="400">Book Now</a>
                <?php endif ?>
              </div>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<!-- Navigation and Pagination (must be inside the swiper container) -->
<!-- <div class="swiper-button-next"></div>
  <div class="swiper-button-prev"></div> -->
<div class="swiper-pagination"></div>
</div>

<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<!-- AOS JS -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<!-- Initialize Swiper and AOS -->
<script>
  // Initialize AOS
  AOS.init({
    once: true, // animations will only happen once
    disable: 'mobile' // disable animations on mobile if needed
  });

  // Initialize Swiper
  var swiper = new Swiper(".bannerSwiper", {
    direction: "vertical",
    // effect: "flip",
    autoplay: {
      delay: 2500,
      disableOnInteraction: true,
    },
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    on: {
      slideChange: function() {
        // Reinitialize AOS on each slide change to trigger animations
        AOS.refresh();
      }
    }
  });
</script>