<!-- Link AOS CSS -->
<link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">

<!-- Link Swiper's CSS -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css" />

<!-- Styles -->
<style>
  .form_container{
    position:absolute;
    background-color:#fff;
    z-index:999;
  }
  .swiper.bannerSwiper {
    height: 700px;
    width: 100%;
  }

  .banner-swiper-slide::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    /* background: rgba(0, 0, 0, 0.2); */
  }

  .swiper-slide img {
    display: block;
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: bottom;
  }

  .text-container {
    position: absolute;
    top: 50%;
    left: 20%;
    z-index: 2;
    color: white;
    transform: translateY(-50%);
  }

  .swiper-button-next,
  .swiper-button-prev {
    color: white;
    z-index: 10;
  }

  .swiper-pagination-bullet {
    background: white;
    z-index: 10;
  }


  .glassmorph {
    background: rgba(255, 255, 255, 0.99);
    /* white with transparency */
    backdrop-filter: blur(15px);
    -webkit-backdrop-filter: blur(15px);
    border-radius: 20px;
    border: 1px solid rgba(255, 255, 255, 0.4);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease-in-out;
  }

  @media (min-width: 992px) {
    .position-lg-absolute {
      position: relative !important;
      top: 50%;
      right: 0;
      transform: translateY(-25%);
      z-index: 1;
    }
  
  }

  /* Responsive styles */
  @media (max-width: 768px) {
    .swiper.bannerSwiper {
      height: 200px;
    }

    .swiper-button-next,
    .swiper-button-prev {
      display: none !important;
    }

    .text-container {
      left: 10%;
      font-size: 14px;
    }
  
  }


  /* Small screens */
@media (max-width: 640px) {

  .swiper-slide img {
    display: block;
    width: 100%;
    height: 100%;
    object-fit: cover;
    object-position: bottom;
  }
  .swiper{
    height: 100px;
    margin-bottom:830px;
  }
  .form_container{
    position:absolute;
    background-color:#fff;
    margin-top:120px!important;
    z-index:999;
    width:83%;
    border: 1px solid rgba(255, 255, 255, 0.4);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);

  }
}



</style>

<!-- Swiper -->

<div class="row">
  <div class="col-lg-4 form_container p-4 m-5">
  <?= $this->Flash->render() ?>

<?= $this->Form->create(NULL, ['url' => ['controller' => 'ContactUs', 'action' => 'donationForm'], "class" => "p-4 w-100", 'id' => "booking-form"]) ?>

    <div class="row">
    <?= $this->Form->hidden('feedback_cat_id', ['value' => 2]) ?>


      <div class="col-lg-6">
       <div class="">
            <span><i class="fas fa-check-circle"></i></span>
            <?= $this->Form->label('check_in', 'Check-in', ['class' => 'fw-bold my-2']) ?>

            <div class="flatpickr d-inline-flex align-items-center border rounded w-100 ">
              <?= $this->Form->text('check_in', [
                'label' => false,
                'class' => 'form-control border-0 shadow-none',
                'placeholder' => 'Check-in',
                'data-input' => true,
                'autocomplete' => 'off'
              ]) ?>

              <a class="input-button px-2 text-decoration-none text-secondary" title="Toggle Calendar" data-toggle>
                <i class="fa fa-calendar-alt"></i>
              </a>
            </div>
          </div>
      </div>


      <div class="col-lg-6">
      <div class="">
            <span><i class="fas fa-sign-out-alt"></i></span>
            <?= $this->Form->label('check_out', 'Check-out', ['class' => 'fw-bold my-2']) ?>

            <div class="flatpickr d-inline-flex align-items-center border rounded w-100">
              <?= $this->Form->text('check_out', [
                'label' => false,
                'class' => 'form-control border-0 shadow-none',
                'placeholder' => 'Check-out',
                'data-input' => true,
                'autocomplete' => 'off'
              ]) ?>

              <a class="input-button px-2 text-decoration-none text-secondary" title="Toggle Calendar" data-toggle>
                <i class="fa fa-calendar-alt"></i>
              </a>
            </div>
          </div>
      </div>



      <div class="col-lg-12 mt-3">
        <div class="row">
           <div class="col-lg-4">
           <div class="">
            <span><i class="fas fa-user"></i></span>
            <?= $this->Form->label('adults', 'Adults', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('adults', [
              'label' => false,
              'type' => 'select',
              'options' => range(0, 5),
              'empty' => 'Select',
              'class' => 'form-control'
            ]) ?>
          </div>
            </div>


            <div class="col-lg-4">
            <div class="">
            <span><i class="fas fa-child"></i></span>
            <?= $this->Form->label('children', 'Children', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('children', [
              'label' => false,
              'type' => 'select',
              'options' => range(0, 5),
              'empty' => 'Select',
              'class' => 'form-control'
            ]) ?>
          </div>
            </div>


            <div class="col-lg-4">
            <div class="">
            <span><i class="fas fa-bed"></i></span>
            <?= $this->Form->label('rooms', 'Rooms', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('rooms', [
              'label' => false,
              'type' => 'select',
              'options' => ['Regular','Standard','Executive'],
              'empty' => 'Select',
              'class' => 'form-control'
            ]) ?>
          </div>
            </div>
        </div>
      </div>



      <div class="col-lg-12 mt-3">

         <div class="">
            <span><i class="fas fa-user-tag"></i></span>
            <?= $this->Form->label('name', 'Name', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('name', [
              'label' => false,
              'placeholder' => 'John Doe',
              'class' => 'form-control'
            ]) ?>
          </div>

      </div>


      <div class="col-lg-12 mt-3">

      <div class="">
            <span><i class="fas fa-envelope"></i></span>
            <?= $this->Form->label('email', 'Email', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('email', [
              'label' => false,
              'placeholder' => 'example@gmail.com',
              'class' => 'form-control',
              'type' => 'email'
            ]) ?>
          </div>

      </div>


      <div class="col-lg-12 mt-3">
      <div class="">
            <span><i class="fas fa-phone-alt"></i></span>
            <?= $this->Form->label('phone', 'Phone Number', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('phone', [
              'label' => false,
              'placeholder' => '000-000-0000',
              'class' => 'form-control'
            ]) ?>
          </div>

      </div>


      <div class="col-lg-12 mt-3">
          <div class="col-md-1 d-flex align-items-end mt-3 m-lg-0 p-lg-0 ">
            <?= $this->Form->button('Submit', ['class' => 'btn btn-custom btn-md fw-bold px-3']) ?>
          </div>
      </div>



    </div>

  <?= $this->Form->end() ?>
  </div>
</div>



<div class="swiper bannerSwiper">
  <div class="swiper-wrapper">
    <?php foreach ($banners as $banner): ?>
      <div class="swiper-slide position-relative banner-swiper-slide">
        <!-- Background Image -->
        <img src="<?= $this->Url->image($banner->image_path) ?>" alt="<?= h($banner->title) ?>" class="img-fluid w-100" />

        <!-- Dark Overlay -->
        <div class="position-absolute top-0 start-0 w-100 h-100 bg-dark opacity-50"></div>

        <!-- Text on Image -->
        <div class="position-absolute top-50 start-50 translate-middle text-white text-center z-3">
          <div class="col-lg-12">
            <div class="row">
              <div class="col-lg-4">
              
              </div>
            </div>
          </div>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>

<!-- Navigation and Pagination (must be inside the swiper container) -->
<!-- <div class="swiper-button-next"></div>
  <div class="swiper-button-prev"></div> -->
<div class="swiper-pagination"></div>
</div>

<script>
  document.addEventListener("DOMContentLoaded", function () {
    flatpickr(".flatpickr", {
      wrap: true,
      minDate: "today",
      dateFormat: "d-m-Y",
      disableMobile: true
    });
  });
</script>

<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>
<!-- AOS JS -->
<script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>

<!-- Initialize Swiper and AOS -->
<script>
  // Initialize AOS
  AOS.init({
    once: true, // animations will only happen once
    disable: 'mobile' // disable animations on mobile if needed
  });

  // Initialize Swiper
  var swiper = new Swiper(".bannerSwiper", {
    direction: "vertical",
    // effect: "flip",
    effect: "fade",
    autoplay: {
      delay: 4500,
      disableOnInteraction: true,
    },
    pagination: {
      el: ".swiper-pagination",
      clickable: true,
    },
    on: {
      slideChange: function() {
        // Reinitialize AOS on each slide change to trigger animations
        AOS.refresh();
      }
    }
  });
</script>


