<style>
  .swiper.bannerSwiper {
    height: 500px;
    width: 100%;
    position: relative;
  }

  .swiper-slide.banner-swiper-slide {
    width: 100%;
    height: 100%;
  }

  .swiper-slide.banner-swiper-slide img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    /* Ensures images cover the area without stretching */
    display: block;
    /* Removes any potential inline spacing */
    transition: transform 5s ease-out;
  }

  /* Slide Gradient Overlay */
  /* .banner-swiper-slide::after {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: linear-gradient(135deg, rgba(0, 0, 0, 0.8) 0%, rgba(0, 0, 0, 0.8) 100%);
    z-index: 1;
  } */

  /* Active Slide Enhancements */
  .swiper-slide-active img {
    transform: scale(1.07);
  }

  .swiper-slide-active::after {
    opacity: 0.8;
  }

  /* Navigation Buttons */
 .bannerSwiper .swiper-button-next,
 .bannerSwiper .swiper-button-prev {
    color: white;
    z-index: 10;
    width: 56px;
    height: 56px;
    background: rgba(255, 255, 255, 0.15);
    backdrop-filter: blur(8px);
    border-radius: 50%;
    transition: all 0.3s ease;
    border: 1px solid rgba(255, 255, 255, 0.2);
  }

 .bannerSwiper .swiper-button-next::after,
 .bannerSwiper .swiper-button-prev::after {
    font-size: 24px;
    font-weight: bold;
  }

  .bannerSwiper .swiper-button-next:hover,
  .swiper-button-prev:hover {
    background: rgba(255, 255, 255, 0.3);
    transform: scale(1.1);
  }

  /* Pagination */
  .swiper-pagination {
    bottom: 30px !important;
  }

  .swiper-pagination-bullet {
    background: white;
    opacity: 0.6;
    width: 10px;
    height: 10px;
    transition: all 0.3s ease;
    margin: 0 8px !important;
  }

  .swiper-pagination-bullet-active {
    opacity: 1;
    width: 24px;
    border-radius: 8px;
    background: linear-gradient(90deg, rgb(212, 209, 209), rgb(64, 64, 69));
  }

  /* Text Container */
  .text-container {
    position: absolute;
    top: 50%;
    right: 5%;
    z-index: 2;
    color: white;
    transform: translateY(-50%);
    max-width: 50%;
    transition: all 0.5s cubic-bezier(0.16, 1, 0.3, 1);
    opacity: 0;
    transform: translateY(-40%) translateX(-20px);
  }

  .start-25{
    margin-left: 12%;
  }

  .swiper-slide-active .text-container {
    opacity: 1;
    transform: translateY(-50%) translateX(0);
  }

  /* Text Styling */
  .slide-title {
    font-size: 3.5rem;
    font-weight: 800;
    line-height: 1.1;
    margin-bottom: 16px;
    text-shadow: 0 2px 4px rgba(0, 0, 0, 0.3);
  }

  .slide-subtitle {
    font-size: 1.25rem;
    line-height: 1.6;
    margin-bottom: 24px;
    opacity: 0.9;
    max-width: 80%;
  }

  /* Responsive Styles */
  @media (max-width: 1200px) {
    .swiper.bannerSwiper {
      height: 500px;
    }

    .slide-title {
      font-size: 2.75rem;
    }

    .text-container {
      max-width: 60%;
    }
  }

  @media (max-width: 768px) {
    .swiper.bannerSwiper {
      height: 400px;
      border-radius: 0;
    }

    .text-container {
      max-width: 80%;
      left: 5%;
    }

    .slide-title {
      font-size: 2rem;
    }

    .slide-subtitle {
      font-size: 1rem;
      max-width: 100%;
    }

    .swiper-button-next,
    .swiper-button-prev {
      display: none !important;
    }

    .swiper-pagination {
      bottom: 20px !important;
    }
  }

  @media (max-width: 480px) {
    .swiper.bannerSwiper {
      height: 300px;
    }

    .text-container {
      max-width: 90%;
    }

    .slide-title {
      font-size: 1.75rem;
    }

    .slide-cta {
      padding: 10px 24px;
      font-size: 0.9rem;
    }

      .start-25{
    margin-left: 20%;
  }
  }
</style>

<!-- Swiper -->
<div class="swiper bannerSwiper">
  <div class="swiper-wrapper">
    <?php foreach ($banners as $banner):  ?>
      <?php $bannerTitleWords = explode(" ", $banner->title);
       $firstWord = array_shift($bannerTitleWords);
    $restOfTitle = implode(" ", array_slice($bannerTitleWords, 0, 4));
      ?>

<?php $bannerDescWords = explode(" ", $banner->description);
       $firstDWord = array_shift($bannerDescWords);
    $restOfDesc = implode(" ", array_slice($bannerDescWords, 0, 4));
      ?>
      <div class="swiper-slide banner-swiper-slide">
        <img src="<?= $this->Url->image($banner->image_path) ?>" alt="<?= h($banner->title) ?>" />
        <!-- <div class="text-container bg-white p-lg-4 opacity-100 rounded-3 p-2 border border-black border-opacity-10">
            <h6 class="display-5s h1 fw-bold mb-3 mb-lg-4 text-dark">
              <span class="text-primary"><//?= h($firstWord) ?></span> <//?= h($restOfTitle) ?>
            </h6>
            <h6 class="display-5s h1 fw-bold mb-3 mb-lg-4 text-dark">
              <span class="text-primary"><//?= h($firstDWord) ?></span> <//?= h($restOfDesc) ?>
            </h6>
           <p class="slide-subtitles mb-3 mb-lg-4 text-dark"><//?= h($banner->description) ?></p> 
          <//?php if (!empty($banner->url_link)): ?>
            <a href="<//?= h($banner->url_link) ?>"
              class="text-decoration-none btn btn-primary px-lg-4 py-lg-3 text-white fw-bold fs-6 position-absolute top-100 start-25 translate-middle">
              Learn More <i class="fas fa-angle-right text-white"></i>

            </a>
          <//?php endif; ?>
        </div> -->

      </div>
    <?php endforeach; ?>
  </div>

  <!-- Navigation and Pagination (must be inside the swiper container) -->
  <div class="swiper-button-next"></div>
  <div class="swiper-button-prev"></div>
  <div class="swiper-pagination"></div>
</div>

<!-- Swiper JS -->
<script src="https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js"></script>


<script>
  document.addEventListener('DOMContentLoaded', function () {
    var swiper = new Swiper(".bannerSwiper", {
      spaceBetween: 0,
      centeredSlides: true,
      autoplay: {
        delay: 5000,
        disableOnInteraction: false,
      },
      pagination: {
        el: ".swiper-pagination",
        clickable: true,
      },
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },
      loop: true, // Consider adding loop for infinite sliding
      speed: 300, // Adjust transition speed if needed
    });
  });
</script>