<style>
    .contemporary-footer {
        background: linear-gradient(135deg, #0f172a 0%, #1e293b 100%);
        color: #f8fafc;
        padding: 60px 0 30px;
    }

    .footer-tagline {
        color: #94a3b8;
        line-height: 1.7;
    }

    .contact-title {
        font-weight: 600;
        color: #ffffff;
        position: relative;
        padding-bottom: 10px;
    }

    .contact-title:after {
        content: '';
        position: absolute;
        bottom: 0;
        left: 0;
        width: 40px;
        height: 2px;
        background: #3b82f6;
    }

    .contact-text {
        color: #e2e8f0;
        line-height: 1.6;
    }

    .contact-link {
        color: #e2e8f0;
        text-decoration: none;
        transition: all 0.2s ease;
    }

    .footer-menus li a {
        color: #94a3b8;
    }

    .contact-link:hover {
        color: #3b82f6;
    }

    .footer-divider {
        border-top: 1px solid rgba(255, 255, 255, 0.08);
    }

    .copyright {
        color: #94a3b8;
    }

    .legal-links a {
        color: #94a3b8;
        text-decoration: none;
        transition: all 0.2s ease;
    }

    .legal-links a:hover {
        color: #ffffff;
    }
</style>

<!-- Contemporary Footer -->
<footer class="contemporary-footer">
    <div class="container">
        <div class="row align-items-start">
            <!-- Brand Section -->
            <div class="col-12 col-lg-4 mb-4 mb-lg-0 text-center text-lg-start">
                <div class="footer-brand mb-3">
                    <?php
                    echo $this->Html->image(
                        $appSettings['SITE-LOGO'],
                        [
                            'class' => 'footer-logo img-fluid',
                            'style' => 'width: 150px; height: auto;'
                        ]
                    );
                    ?>
                </div>
                <?php if (!empty($aboutUsFooterContent->content)): ?>
                    <p class="footer-tagline mb-3 mb-md-0"><?= $aboutUsFooterContent->content ?></p>
                <?php endif; ?>
            </div>

            <div class="col-12 col-md-6 col-lg-3 mb-4 mb-lg-0">
                <div class="footer-menus">
                    <?php foreach ($footerMenus as $footerMenu): ?>
                        <ul class="list-unstyled text-center text-md-start">
                            <li class="mb-2">
                                <a href="<?= $this->Url->build(['controller' => $footerMenu->slug, 'action' => 'index']) ?>" class="text-decoration-none">
                                    <?= h($footerMenu->name) ?>
                                </a>
                            </li>
                        </ul>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- Contact Section -->
            <div class="col-12 col-md-6 col-lg-4 offset-lg-1">
                <div class="bg-whites bg-opacity-5 rounded-3 p-3 p-md-4 h-100 border border-white border-opacity-10">
                    <h4 class="contact-title mb-3">Get in Touch</h4>
                    <div class="d-flex mb-3">
                        <i class="fas fa-phone-alt text-primary me-3 mt-1"></i>
                        <div class="contact-text">
                            <a href="#" class="contact-link d-block mb-1 text-break"><?= $contacts->phone1 ?></a>
                            <a href="#" class="contact-link d-block mb-1 text-break"><?= $contacts->phone2 ?></a>
                            <a href="#" class="contact-link d-block mb-1 text-break"><?= $contacts->phone3 ?></a>
                        </div>
                    </div>
                    <div class="d-flex mb-3">
                        <i class="fas fa-envelope text-primary me-3 mt-1"></i>
                        <div class="contact-text">
                            <a href="mailto:<?= $contacts->email1 ?>" class="contact-link d-block mb-1 text-break"><?= $contacts->email1 ?></a>
                            <a href="mailto:<?= $contacts->email1 ?>" class="contact-link d-block mb-1 text-break"><?= $contacts->email2 ?></a>
                            <a href="mailto:<?= $contacts->email1 ?>" class="contact-link d-block mb-1 text-break"><?= $contacts->email3 ?></a>
                        </div>
                    </div>
                    <div class="d-flex">
                        <i class="fas fa-map-marker-alt text-primary me-3 mt-1"></i>
                        <div class="contact-text">
                            <?= $contacts->address1 ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="footer-divider my-4 my-md-5"></div>

        <div class="row">
            <div class="col-12 text-center">
                <p class="copyright mb-0">© <?php echo date("Y"); ?> <?= $appSettings['SITE-NAME']; ?>. All rights reserved.</p>
            </div>
        </div>
    </div>
</footer>