<style>
  .glassmorph {
    background: rgba(255, 255, 255, 0.99);
    /* white with transparency */
    backdrop-filter: blur(15px);
    -webkit-backdrop-filter: blur(15px);
    border-radius: 20px;
    border: 1px solid rgba(255, 255, 255, 0.4);
    box-shadow: 0 8px 32px rgba(0, 0, 0, 0.1);
    transition: all 0.3s ease-in-out;
  }

  @media (min-width: 992px) {
    .position-lg-absolute {
      position: relative !important;
      top: 50%;
      right: 0;
      transform: translateY(-25%);
      z-index: 1;
    }
  }
</style>

<section class="">
  <div class="container position-lg-absolute">
    <div class="row">
      <div class="col-l2 col-lg-12">
        <?= $this->Flash->render() ?>

        <?= $this->Form->create(NULL, ['url' => ['controller' => 'ContactUs', 'action' => 'donationForm'], "class" => "shadow rounded-3 p-4 w-100  glassmorph", 'id' => "booking-form"]) ?>

        <div class="row mb-2 justify-content-start">

          <?= $this->Form->hidden('feedback_cat_id', ['value' => 2]) ?>

          <div class="col-md-3">
            <span><i class="fas fa-check-circle"></i></span>
            <?= $this->Form->label('check_in', 'Check-in', ['class' => 'fw-bold my-2']) ?>

            <div class="flatpickr d-inline-flex align-items-center border rounded w-100 ">
              <?= $this->Form->text('check_in', [
                'label' => false,
                'class' => 'form-control border-0 shadow-none',
                'placeholder' => 'Check-in',
                'data-input' => true,
                'autocomplete' => 'off'
              ]) ?>

              <a class="input-button px-2 text-decoration-none text-secondary" title="Toggle Calendar" data-toggle>
                <i class="fa fa-calendar-alt"></i>
              </a>
            </div>
          </div>

          <div class="col-md-3">
            <span><i class="fas fa-sign-out-alt"></i></span>
            <?= $this->Form->label('check_out', 'Check-out', ['class' => 'fw-bold my-2']) ?>

            <div class="flatpickr d-inline-flex align-items-center border rounded w-100">
              <?= $this->Form->text('check_out', [
                'label' => false,
                'class' => 'form-control border-0 shadow-none',
                'placeholder' => 'Check-out',
                'data-input' => true,
                'autocomplete' => 'off'
              ]) ?>

              <a class="input-button px-2 text-decoration-none text-secondary" title="Toggle Calendar" data-toggle>
                <i class="fa fa-calendar-alt"></i>
              </a>
            </div>
          </div>

          <div class="col-md-2">
            <span><i class="fas fa-user"></i></span>
            <?= $this->Form->label('adults', 'Adults', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('adults', [
              'label' => false,
              'type' => 'select',
              'options' => range(0, 5),
              'empty' => 'Select',
              'class' => 'form-control'
            ]) ?>
          </div>

          <div class="col-md-2">
            <span><i class="fas fa-child"></i></span>
            <?= $this->Form->label('children', 'Children', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('children', [
              'label' => false,
              'type' => 'select',
              'options' => range(0, 5),
              'empty' => 'Select',
              'class' => 'form-control'
            ]) ?>
          </div>

            <div class="col-md-2">
            <span><i class="fas fa-bed"></i></span>
            <?= $this->Form->label('rooms', 'Rooms', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('rooms', [
              'label' => false,
              'type' => 'select',
              'options' => ['Regular','Standard','Executive'],
              'empty' => 'Select',
              'class' => 'form-control'
            ]) ?>
          </div>


        </div>

        <div class="row">

          <div class="col-md-4">
            <span><i class="fas fa-user-tag"></i></span>
            <?= $this->Form->label('name', 'Name', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('name', [
              'label' => false,
              'placeholder' => 'John Doe',
              'class' => 'form-control'
            ]) ?>
          </div>

          <div class="col-md-4">
            <span><i class="fas fa-envelope"></i></span>
            <?= $this->Form->label('email', 'Email', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('email', [
              'label' => false,
              'placeholder' => 'example@gmail.com',
              'class' => 'form-control',
              'type' => 'email'
            ]) ?>
          </div>

          <div class="col-md-3">
            <span><i class="fas fa-phone-alt"></i></span>
            <?= $this->Form->label('phone', 'Phone Number', ['class' => 'fw-bold my-2']) ?>
            <?= $this->Form->control('phone', [
              'label' => false,
              'placeholder' => '000-000-0000',
              'class' => 'form-control'
            ]) ?>
          </div>

          <div class="col-md-1 d-flex align-items-end mt-3 m-lg-0 p-lg-0 ">
            <?= $this->Form->button('Submit', ['class' => 'btn btn-custom btn-md fw-bold px-3']) ?>
          </div>

        </div>

        <?= $this->Form->end() ?>

      </div>
    </div>
  </div>
</section>

<script>
  document.addEventListener("DOMContentLoaded", function () {
    flatpickr(".flatpickr", {
      wrap: true,
      minDate: "today",
      dateFormat: "d-m-Y",
      disableMobile: true
    });
  });
</script>