<section class="py-3 py-md-4">
  <div class="container">
    <div class="row">
      <?php foreach ($viewContent as $content): ?>

        <?php $link = $this->Url->build([
          'controller' => $this->request->getParam('subsection') ?: ($this->request->getParam('section') ?: $this->request->getParam('controller')),
          'action' => 'details',
          $content->id
        ]) ?>

        <div class="col-12 col-lg-6 mb-md-5">

          <div class="card">

            <a href="<?= $link ?>">
              <img
                src="<?= $this->Url->image(!empty($content->content_images) && !empty($content->content_images[0]->image_path) ? $content->content_images[0]->image_path : 'noimage.png') ?>"
                class="card-img-top" alt="...">
            </a>
            
            <div class="card-body">

              <!-- Main heading -->
              <h2 class="fs-3 fw-medium mb-md-4" data-bs-toggle="tooltip" data-bs-placement="top"
                title="<?= $content->name ?>">
                <a href="<?= $link ?>" class="text-decoration-none text-dark">
                  <?= $this->Text->truncate(strip_tags($content->name), 30, ['ellipsis' => '...', 'exact' => false]) ?>
                </a>
              </h2>

              <!-- Content section -->
              <div class="fs-6 mb-4 text-muted">
                <?= $this->Text->truncate(strip_tags($content->content), 99, ['ellipsis' => '...', 'exact' => false]) ?>
              </div>

              <!-- Call-to-action button -->
              <a href="<?= $link ?>" class="btn btn-secondary btn-md fw-bold">
                Read More
              </a>
            </div>

          </div>

        </div>
      <?php endforeach ?>
    </div>
  </div>
</section>