<style>
.rooms_bg{
  background-color: rgba(170, 132, 83, 0.1) 
}



.card {
  width: 300px;
  margin: 40px;
  background-color: white;
  box-shadow: 0 5px 10px 0 rgba(0, 0, 0, 0.5);
}
.card:hover .card_caption {
  top: 90%;
  transform: translateY(-90%);
}
.card:hover .card_image {
  transform: translateY(-10px);
}
.card:hover .card_thumb::after {
  top: 0;
}
.card:hover .card_snippet {
  margin: 20px 0;
}
.card_thumb {
  position: relative;
  max-height: 400px;
  overflow: hidden;
}
.card_thumb::after {
  position: absolute;
  top: 0;
  display: block;
  content: "";
  width: 100%;
  height: 100%;
  background: linear-gradient(0deg, rgba(0, 0, 0, 0.5) 40%, rgba(255, 255, 255, 0) 100%);
  transition: 0.3s;
}
@media (min-width: 1024px) {
  .card_thumb::after {
    top: calc(100% - 140px);
  }
}
.card_image {
  transition: 0.5s ease-in-out;
}
.card_caption {
  position: absolute;
  top: 50%;
  z-index: 1;
  padding: 0 20px;
  color: white;
  transform: translateY(-50%);
  text-align: center;
  transition: 0.3s;
}
@media (min-width: 1024px) {
  .card_caption {
    top: calc(100% - 110px);
    transform: unset;
  }
}
.card_title {
  display: -webkit-box;
  max-height: 85px;
  overflow: hidden;
  font-family: "Playfair Display", serif;
  font-size: 23px;
  line-height: 28px;
  text-shadow: 0px 1px 5px black;
  text-overflow: ellipsis;
  -webkit-line-clamp: 3;
  -webkit-box-orient: vertical;
}
.card_snippet {
  display: -webkit-box;
  max-height: 150px;
  margin: 20px 0;
  overflow: hidden;
  font-family: "Roboto", sans-serif;
  font-size: 16px;
  line-height: 20px;
  text-overflow: ellipsis;
  transition: 0.5s ease-in-out;
  -webkit-line-clamp: 5;
  -webkit-box-orient: vertical;
}
@media (min-width: 1024px) {
  .card_snippet {
    margin: 60px 0;
  }
}
.card_button {
  display: inline-block;
  padding: 10px 20px;
  color: white;
  border: 1px solid white;
  font-family: "Roboto", sans-serif;
  font-size: 12px;
  text-transform: uppercase;
  text-decoration: none;
  transition: 0.3s;
}
.card_button:hover {
  color: black;
  background-color: white;
}

.disclaimer {
  position: fixed;
  bottom: 0;
  left: 50%;
  z-index: 2;
  box-sizing: border-box;
  width: 100%;
  padding: 20px 10px;
  background-color: white;
  transform: translateX(-50%);
  font-family: "Roboto", sans-serif;
  font-size: 14px;
  text-align: center;
}
.disclaimer_link {
  color: #755D87;
  text-decoration: none;
}


</style>

<section class="py-3 py-md-5 rooms_bg">
  <div class="container">


  <div class="row justify-content-center">
    <div class="col-12 col-md-10 col-lg-7">
      <div class="sec-title text-center text-lg-center mb-4 mb-md-5 mt-md-1">
      
        <!-- Decorative Divider -->
        <div class="d-flex justify-content-center align-items-center mb-3">
          <i class="fa-solid fa-snowflake me-3 text-danger"></i>
          <span class="text-danger">Customer Services</span>
          <i class="fa-solid fa-snowflake ms-3 text-danger"></i>
        </div>

     
      <h1>Book your stay and <br>relax in luxury</h1>
       
        
      </div>
    </div>
  </div>

  
 



    <div class="container">
    <?php foreach($viewContent as $key => $content) { ?>

      <?php $link = $this->Url->build([
          'controller' => $this->request->getParam('subsection') ?: ($this->request->getParam('section') ?: $this->request->getParam('controller')),
          'action' => 'details',
          $content->id
        ]) ?>

      
        
        <div class="card">
		<figure class="card_thumb">
    <img
                    src="<?= $this->Url->image(sizeof($content->content_images) > 0 ? $content->content_images[0]->image_path : 'noimage.png') ?>"
                    class="img-responsive img-fluid card_image" alt="<?= h($viewContent[0]->name) ?>" />
			<figcaption class="card_caption">
				<h2 class="card_title"><?= $content->name ?></h2>
				<br>
				<br>
				<p class="card_snippet"></p>
				<a href="" class="card_button">Read more</a>
			</figcaption>
		</figure>
	</div>
       
       
        <?php }?>
    </div>
  </div>
  </div>
</section>