<!-- Custom CSS for lightbox -->
<style>
  .gallery-img {
    cursor: pointer;
    transition: transform 0.2s;
    margin-bottom: 15px;
  }

  .gallery-img:hover {
    transform: scale(1.02);
  }

  /* Lightbox modal customization */
  #lightboxModal .modal-dialog {
    max-width: 90%;
    max-height: 90vh;
  }

  #lightboxModal .modal-content {
    background: transparent;
    border: none;
  }

  #lightboxModal .modal-body {
    padding: 0;
    text-align: center;
  }

  #lightboxModal img {
    max-height: 80vh;
    width: auto;
    max-width: 100%;
  }

  #lightboxCaption {
    color: white;
    text-align: center;
    padding: 10px;
  }

  .lightbox-nav {
    position: absolute;
    top: 50%;
    transform: translateY(-50%);
    background: rgba(0, 0, 0, 0.5);
    color: white;
    border: none;
    border-radius: 50%;
    width: 40px;
    height: 40px;
    font-size: 1.5rem;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1;
  }

  .lightbox-nav:hover {
    background: rgba(0, 0, 0, 0.8);
  }

  .lightbox-prev {
    left: 15px;
  }

  .lightbox-next {
    right: 15px;
  }

  .close-lightbox {
    position: absolute;
    top: 15px;
    right: 15px;
    color: white;
    opacity: 0.8;
    font-size: 2rem;
    z-index: 1;
    background: none;
    border: none;
  }

  .close-lightbox:hover {
    opacity: 1;
  }
</style>

<div class="container">
  <div class="row gallery">
    <!-- Gallery items will be added here -->
    <?php foreach ($galleryDetails as $key => $content) { ?>
      <div class="col-md-4 col-sm-6 mb-4">
        <div class="three_col_img_div">
          <img src="<?= $this->Url->image($content->image_path) ?>" alt="" class="img-fluid rounded gallery-img"
            data-bs-toggle="modal" data-bs-target="#lightboxModal" data-index="0">
          <!-- <p class="text-center mt-2">Image 1</p> -->
        </div>
      </div>
    <?php } ?>

    <!-- Add more images as needed -->
  </div>
</div>

<!-- Lightbox Modal -->
<div class="modal fade" id="lightboxModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-body">
        <button type="button" class="close-lightbox" data-bs-dismiss="modal" aria-label="Close">&times;</button>
        <img id="lightboxImage" src="" alt="" class="img-fluid">
        <div id="lightboxCaption"></div>
        <button class="lightbox-nav lightbox-prev" onclick="changeImage(-1)">&#10094;</button>
        <button class="lightbox-nav lightbox-next" onclick="changeImage(1)">&#10095;</button>
      </div>
    </div>
  </div>
</div>

<!-- Lightbox JavaScript -->
<script>
  // Initialize lightbox
  document.addEventListener('DOMContentLoaded', function () {
    const galleryImages = document.querySelectorAll('.gallery-img');
    const lightboxModal = document.getElementById('lightboxModal');
    const lightboxImage = document.getElementById('lightboxImage');
    const lightboxCaption = document.getElementById('lightboxCaption');

    // Store all gallery images
    const images = Array.from(galleryImages);
    let currentIndex = 0;

    // Add click event to each image
    galleryImages.forEach(img => {
      img.addEventListener('click', function () {
        currentIndex = parseInt(this.getAttribute('data-index'));
        updateLightboxImage();
      });
    });

    // Function to update lightbox image
    function updateLightboxImage() {
      const activeImage = images[currentIndex];
      lightboxImage.src = activeImage.src;
      lightboxImage.alt = activeImage.alt;
      lightboxCaption.textContent = activeImage.alt;
    }

    // Make the function available globally for the nav buttons
    window.changeImage = function (step) {
      currentIndex += step;

      // Wrap around if at beginning or end
      if (currentIndex >= images.length) {
        currentIndex = 0;
      } else if (currentIndex < 0) {
        currentIndex = images.length - 1;
      }

      updateLightboxImage();
    };

    // Keyboard navigation
    document.addEventListener('keydown', function (e) {
      if (lightboxModal.classList.contains('show')) {
        if (e.key === 'ArrowLeft') {
          changeImage(-1);
        } else if (e.key === 'ArrowRight') {
          changeImage(1);
        } else if (e.key === 'Escape') {
          bootstrap.Modal.getInstance(lightboxModal).hide();
        }
      }
    });
  });
</script>