<style>
  .bg_safe{
    background-color:#dfe2eb;
  }

  .s_zoom {
  transition: transform .2s; /* Animation */
}

.s_zoom:hover {
  transform: scale(1.1); /* (150% zoom - Note: if the zoom is too large, it will go outside of the viewport) */
}
  
  .safe_icon_back{
    background-color:#4e567d;
    color:#fff;
  }
  .image-card {
    position: relative;
    margin-bottom: 20px;
    overflow: hidden;
    border-radius: 5px;
  }

  .image-card img {
    width: 100%;
    height: 300px;
    /* Fixed height for consistency */
    object-fit: cover;
    display: block;
    transition: transform 0.3s ease;
  }

  .image-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.2);
    transition: background 0.3s ease;
  }

  .image-content {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    padding: 20px;
    color: white;
  }

  .image-card:hover img {
    transform: scale(1.05);
  }

  .image-card:hover .image-overlay {
    background: rgba(0, 0, 0, 0.7);
  }

  .image-title {
    font-weight: 600;
    font-size: 1.25rem;
    margin-bottom: 0.5rem;
  }

  .image-description {
    margin-bottom: 0;
  }

  .bg-gold {
    background-color: #109333;
  }

  .btn-navy {
    background-color: #2C3E50;
    color: #F1C40F;
    font-weight: 600;
    padding: 12px 30px;
    border-radius: 0;
  }

  .text-navy {
    color: #fff;
  }

  .text-gold {
    color: #F1C40F;
  }

  .bg-navy {
    background-color: #f5f6f8;
  }



  /* .service-tab-left p {
  margin: 25px 0;
} */

.cta-btn {
  font-size: 17px;
  font-weight: 600;
  color: #fff;
  letter-spacing: 1px;
  /* text-transform: uppercase; */
  padding: 10px 30px;
  background: transparent;
  border: 1px solid #fff;
  border-radius: 30px;
  position: relative;
  vertical-align: middle;
  display: inline-block;
  -webkit-transform: perspective(1px) translateZ(0);
  transform: perspective(1px) translateZ(0);
}


.cta-btn a {
  color: #fff!important;
}

.cta-btn a:hover {
  color: #000!important;
}

.cta-btn:before {
  content: "";
  position: absolute;
  z-index: -1;
  top: 0;
  bottom: 0;
  left: 0;
  right: 0;
  color:#fff;
  background: #fff;
  border-radius: 30px;
  -webkit-transform-origin: 50%;
  transform-origin: 50%;
  -webkit-transition-property: transform;
  transition-property: transform;
  -webkit-transition-duration: 0.3s;
  transition-duration: 0.3s;
  -webkit-transition-timing-function: ease-out;
  transition-timing-function: ease-out;
  -webkit-transform: scaleX(0);
  transform: scaleX(0);
}

.cta-btn:hover:before,
.cta-btn:focus:before,
.cta-btn:active:before {
  -webkit-transform: scaleY(1);
  transform: scaleY(1);
}

.cta-btn:hover,
.cta-btn:focus,
.cta-btn:active {
  color: #000;
  border-color: #fff;
}

</style>

<section id="" class="bg_safe py-5">
  <div class="container">

    <div class="row mb-5 align-items-end">
      <div class="col-lg-6 mb-3 mb-lg-0">
        <h1 class="mb-3 fs-5 fw-normal text-darkred">— Safe Measures</h1>
        <h2 class="fw-bold">Keep your working environment safe and secure</h2>
      </div>
      <div class="col-lg-6 text-align-end text-lg-end pb-4">
        <a href="#"><span class="btn service-btn btn-lg">View More <i class="bi bi-arrow-right"></i></span></a>
      </div>
    </div>

    <div class="row">
    <?php foreach ($viewContent as $content): ?>
          <?php $link = $this->Url->build([
          'controller' => $this->request->getParam('subsection') ?: ($this->request->getParam('section') ?: $this->request->getParam('controller')),
          'action' => 'details',
          $content->id
        ]) ?>

        <div class="col-md-6 gx-4 s_zoom">
        <div class="container card h-100 g-4">
          <div class="row h-100">
              <div class="col-md-3 safe_icon_back d-flex justify-content-center">
                  <i class="bi <?= $content->fa_icon ?> fs-2" class=""></i>
              </div>

              <div class="col-md-9 p-3 bg-light">
                <h5 class="mt-3 fw-bold text-blue"><?= $content->name ?> eeee</h5>
              </div>
          </div>
          </div>
        </div>
        <?php endforeach ?>

    </div>

  </div>
</section>

<section class="py-5 bg-gold">
  <div class="container py-5">
    <div class="row align-items-center">
      <div class="col-lg-8 text-center text-lg-start">
        <h1 class="fw-bold fs-1 mb-3 text-navy">Ghana Institute of Safety and Environmental Protection - GhISEP</h1>
        <p class="lead mb-0 text-navy">Promoting Health, Safety and Environmental (HSE)
        Sustainability through Professional Excellence.</p>
      </div>
      <div class="col-lg-4 text-center text-lg-end mt-4 mt-lg-0">
      <a href="#"><span class="btn cta-btn btn-lg">Contact Us Now <i class="bi bi-telephone-fill ms-2"></i></span></a>
      </div>
    </div>
  </div>
</section>