<section class="py-3 py-md-5">
  <div class="container">
    <div class="row">
      <?php foreach ($viewContent as $content): ?>

        <?php $link = $this->Url->build(['controller' => $slug, 'action' => 'details', $content->id]) ?>

        <div class="col-12 col-lg-3 mb-3">
          <!-- Image -->
          <div class="three_col_img_div mb-2 mb-md-4">
            <a href="<?= $link ?>">
              <img
                src="<?= $this->Url->image(!empty($content->content_images) && !empty($content->content_images[0]->image_path) ? $content->content_images[0]->image_path : 'noimage.png') ?>"
                class="img-fluid w-100 rounded-3" alt="<?= h($content->name) ?>" />
            </a>
          </div>

          <!-- Main heading -->
          <a href="<?= $link ?>" class="text-decoration-none text-dark">
            <h2 class="fs-3 fw-medium mb-md-4"><?= $content->name ?></h2>
          </a>

          <!-- Content section -->
          <div class="fs-6 mb-4 text-muted">
            <?= $this->Text->truncate(strip_tags($content->content), 90, ['ellipsis' => '...', 'exact' => false]) ?>
          </div>

          <!-- Call-to-action button -->
          <a href="<?= $link ?>" class="btn btn-secondary btn-md fw-bold mb-4">
            Read More
          </a>

        </div>
      <?php endforeach ?>
    </div>
  </div>
</section>