<!-- Swiper CSS -->
<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css" />
<style>
.testimonial-section {
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    position: relative;
    overflow: hidden;
    padding-top: 4rem;
    padding-bottom: 4rem;
}
.testimonial-section::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color:rgba(3, 79, 150, 0.82);
    z-index: 0;
}
.testimonial-section > .container {
    position: relative;
    z-index: 1;
}

.testimonial-section .profile {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    border: 2px solid #ddd;
    margin: 0 auto;
    overflow: hidden;
    box-shadow: 0 4px 8px rgba(255, 255, 255, 0.1);
    transition: transform 0.3s ease;
}
.testimonial-section .profile img {
    width: 100%;
    height: 100%;
    object-fit: cover;
}
.testimonial-section .profile:hover {
    transform: scale(1.05);
}

.testimonial-section .testimonial-text {
    font-style: italic;
    line-height: 1.6;
    position: relative;
}
.testimonial-section .testimonial-text::before,
.testimonial-section .testimonial-text::after {
    font-family: Arial, sans-serif;
    font-size: 3rem;
    color: #ccc;
    position: absolute;
}
.testimonial-section .testimonial-text::before {
    content: '“';
    left: -20px;
    top: -10px;
}
.testimonial-section .testimonial-text::after {
    content: '”';
    right: -20px;
    bottom: -10px;
}

.testimonial-section .testimonial-slide {
    animation: fadeInUp 1s ease-in-out both;
}
@keyframes fadeInUp {
    0% {
        opacity: 0;
        transform: translateY(30px);
    }
    100% {
        opacity: 1;
        transform: translateY(0);
    }
}

.testimonial-section .swiper-button-next,
.testimonial-section .swiper-button-prev {
    color: #fff;
    z-index: 2;
    top: 50%;
    transform: translateY(-50%);
    width: 40px;
    height: 40px;
    background-color: rgba(255, 255, 255, 0.15);
    border-radius: 50%;
    backdrop-filter: blur(4px);
    transition: background-color 0.3s ease;
}
.testimonial-section .swiper-button-next:hover,
.testimonial-section .swiper-button-prev:hover {
    background-color: rgba(255, 255, 255, 0.4);
}
.testimonial-section .swiper-button-next::after,
.testimonial-section .swiper-button-prev::after {
    font-size: 20px;
    font-weight: bold;
}

.testimonial-section .swiper-pagination-bullet {
    background: #fff;
    opacity: 0.7;
}
.testimonial-section .swiper-pagination-bullet-active {
    opacity: 1;
    background: #035096;
}
</style>

<section class="testimonial-section bg-light">
    <div class="container">
        <div class="row justify-content-center align-content-center mb-lg-2">
            <div class="col-12 col-lg-7">
                <h1 class="display-5 fw-medium text-center text-white">What Our Customers Say</h1>
            </div>
        </div>

        <div class="testimonial-carousel">
            <div class="swiper testimonialSwiper">
                <div class="swiper-wrapper">
                    <?php foreach ($viewContent as $key => $content): ?>
                        <div class="swiper-slide">
                            <div class="row justify-content-center py-5">
                                <div class="col-12 col-md-9 col-lg-7">
                                    <div class="testimonial-slide text-white text-center">
                                        <div class="profile mb-4">
                                            <img
                                                src="<?= $this->Url->image(!empty($content->content_images[0]->image_path) ? $content->content_images[0]->image_path : 'noimage.png') ?>"
                                                class="img-fluid" alt="<?= h($content->name) ?>" loading="lazy" />
                                                                                        </div>

                                        <div class="testimonial-author fw-bold fs-5 mb-3"><?= $content->name ?></div>

                                        <div class="testimonial-text mb-3 fs-5">
                                            <?= $content->content ?>
                                        </div>
                                        
                                        <div class="testimonial-role fw-semibold"><?= $content->caption ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach ?>
                </div>

                <div class="swiper-pagination"></div>
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
        </div>
    </div>
</section>

<!-- Swiper JS -->
<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

<script>
    var swiper = new Swiper(".testimonialSwiper", {
        slidesPerView: 1,
        spaceBetween: 30,
        loop: true,
        autoplay: {
            delay: 5000,
            disableOnInteraction: false,
        },
        pagination: {
            el: ".swiper-pagination",
            clickable: true,
        },
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        breakpoints: {
            240: { slidesPerView: 1, spaceBetween: 10 },
            480: { slidesPerView: 1, spaceBetween: 20 },
            768: { slidesPerView: 1, spaceBetween: 30 },
            1024: { slidesPerView: 1, spaceBetween: 40 },
            1200: { slidesPerView: 1, spaceBetween: 50 }
        }
    });
</script>
