<!-- Swiper CSS -->
<link rel="stylesheet" href="https://unpkg.com/swiper/swiper-bundle.min.css">
<style>
.bg-img {
    background-image: url('https://executivepurposefulladiesministry.org/site/img/background-img.jpg');
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    position: relative;
}
.bg-img::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-color: rgba(0, 0, 0, 0.8); /* Adjust opacity (0.5) as needed */
    z-index: 0;
} 
.bg-img > .container {
    position: relative;
    z-index: 1;
}
</style>

<section class="py-lg-5 bg-img">
    <div class="container">

        <div class="row justify-content-center align-content-center mb-lg-2">
            <div class="col-12 col-lg-7">
                <h1 class="display-5 fw-medium text-center text-white">Testimonial</h1>
            </div>
        </div>

        <div class="testimonial-carousel">
            <div class="swiper testimonialSwiper">
                <div class="swiper-wrapper">
                    <?php foreach ($viewContent as $key => $content): ?>
                        <div class="swiper-slide">
                            <!-- Bootstrap grid INSIDE the slide -->
                            <div class="row justify-content-center py-5">
                                <div class="col-12 col-md-9 col-lg-7">
                                    <div class="testimonial-slide text-white">
                                        <div class="testimonial-text text-center mb-3 fs-5">
                                            <?= $content->content ?>
                                        </div>
                                        <div class="testimonial-author text-center fw-bold fs-5"><?= $content->name ?></div>
                                        <div class="testimonial-role text-center fw-semibold"><?= $content->caption ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach ?>
                </div>

                <!-- Add pagination -->
                <div class="swiper-pagination"></div>
                <!-- Add navigation buttons -->
                <div class="swiper-button-next"></div>
                <div class="swiper-button-prev"></div>
            </div>
        </div>

    </div>
</section>

<!-- Swiper JS -->
<script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script>

<!-- Initialize Swiper -->
<script>
    var swiper = new Swiper(".testimonialSwiper", {
        slidesPerView: 1,
        spaceBetween: 30,
        loop: true,
        autoplay: {
            delay: 5000,
            disableOnInteraction: false,
        },
        pagination: {
            el: ".swiper-pagination",
            clickable: true,
        },
        navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
        },
        breakpoints: {
            240: {
                slidesPerView: 1,
                spaceBetween: 10,
            },
            480: {
                slidesPerView: 1,
                spaceBetween: 20,
            },
            768: {
                slidesPerView: 1,
                spaceBetween: 30,
            },
            1024: {
                slidesPerView: 1,
                spaceBetween: 40,
            },
            1200: {
                slidesPerView: 1,
                spaceBetween: 50,
            }
        }
    });
</script>