<section class="py-3 py-md-5">
  <div class="container">
    <div class="row gy-md-4">
      <?php foreach ($viewContent as $content): ?>

        <?php $link = $this->Url->build([
          'controller' => $this->request->getParam('subsection') ?: ($this->request->getParam('section') ?: $this->request->getParam('controller')),
          'action' => 'details',
          $content->id
        ]) ?>

        <!-- text area with padding -->
        <div class="col-12 col-lg-6 mb-3 d-flex align-items-center">
          <div>
            <!-- Main heading -->
            <a href="<?= $link?>" class="text-decoration-none text-dark">
              <h1 class="fs-2 fw-medium mb-md-4"><?= $content->name ?></h1>
            </a>

            <!-- Content section -->
            <div class="fs-6 mb-4 text-muted">
              <?= $this->Text->truncate(strip_tags($content->content), 300, ['ellipsis' => '...', 'exact' => false]) ?>
            </div>

            <!-- Call-to-action button -->
            <a href="<?= $link?>" class="btn btn-secondary btn-md fw-bold mb-4">
              Read More
            </a>
          </div>
        </div>


        <!-- image area -->
        <div class="col-12 col-lg-6 mb-3">
          <div class="three_col_img_div">
            <img
              src="<?= $this->Url->image(!empty($content->content_images) ? $content->content_images[0]->image_path : 'noimage.png') ?>"
              class="img-fluid rounded-4" />
          </div>
        </div>

      <?php endforeach ?>
    </div>
  </div>
</section>