<section class="py-3 py-md-4">
<div class="container-fluid px-3 px-md-5">

<div class="row justify-content-center">
  <div class="col-12 col-md-10 col-lg-8 col-xl-7">
    <div class="section-header text-center mb-4 mb-md-5">
      <h1 class="mb-2 mb-md-3 fw-medium display-6 display-md-5" data-aos="fade-up" data-aos-duration="600"><?= $menuDetails->name ?></h1>
      <p class="lead mb-0 mb-md-4" data-aos="fade-up" data-aos-duration="600" data-aos-delay="100"><?= $menuDetails->content ?></p>
    </div>
  </div>
</div>

<div class="row g-3">
  <?php foreach ($viewContent as $index => $contents): ?>
    <div class="col-12 col-sm-6 col-lg-4 mb-3" data-aos="fade-up" data-aos-delay="<?= ($index % 3) * 100 ?>">

      <div class="card border-1 shadow h-100 d-flex flex-column">
        <!-- Image Area -->
        <div class="two_col_img_div overflow-hidden mb-md-4" data-aos="zoom-in" data-aos-delay="<?= ($index % 3) * 100 + 100 ?>">
          <img
            src="<?= $this->Url->image(!empty($contents->content_images) && !empty($contents->content_images[0]->image_path) ? $contents->content_images[0]->image_path : 'noimage.png') ?>"
            class="img-fluid w-100" 
            alt="<?= h($contents->name) ?>" 
            data-aos="fade-in"
            data-aos-delay="<?= ($index % 3) * 100 + 200 ?>"
          />
        </div>

        <!-- Card Content -->
        <div class="card-body py-3 px-3 px-md-4 pb-md-5 d-flex flex-column">
          <div class="mb-3 mb-md-4" data-aos="fade-up" data-aos-delay="<?= ($index % 3) * 100 + 150 ?>">
            <div class="d-flex flex-column flex-md-row align-items-start align-items-md-center">
              <?php if (!empty($contents->fa_icon)): ?>
                <div class="mb-2 mb-md-0 me-md-3" data-aos="fade-right" data-aos-delay="<?= ($index % 3) * 100 + 200 ?>">
                  <i
                    class="<?= $contents->fa_icon ?> fs-4 bg-pink text-white rounded-circle d-inline-flex justify-content-center align-items-center rounded-circle-icon_size p-3"></i>
                </div>
              <?php endif ?>
              <h4 class="card-title fw-bold fs-5 mb-0 text-dark" data-aos="fade-up" data-aos-delay="<?= ($index % 3) * 100 + 250 ?>">
                <?= $this->Text->truncate(strip_tags($contents->name), 40, ['ellipsis' => '...', 'exact' => false]) ?>
              </h4>
            </div>
          </div>

          <p class="card-text text-muted fw-semibold flex-grow-1" data-aos="fade-up" data-aos-delay="<?= ($index % 3) * 100 + 300 ?>">
            <?= $this->Text->truncate(strip_tags($contents->content), 125, ['ellipsis' => '...', 'exact' => false]) ?>
          </p>

          <!-- Button -->
          <a href="" class="text-decoration-none fw-semibold text-dark" data-aos="fade-up" data-aos-delay="<?= ($index % 3) * 100 + 350 ?>">
            <span class="btn btn-custom-pink btn-sm me-2 px-md-3 py-md-2" data-aos="fade-right" data-aos-delay="<?= ($index % 3) * 100 + 400 ?>">
              <i class="fas fa-chevron-right"></i>
            </span>
            <span data-aos="fade-left" data-aos-delay="<?= ($index % 3) * 100 + 400 ?>">Learn More</span>
          </a>
          
        </div>
      </div>

    </div>
  <?php endforeach ?>
</div>
</div>
</section>