<style>
  .image-card {
    position: relative;
    margin-bottom: 20px;
    overflow: hidden;
    border-radius: 5px;
  }

  .image-card img {
    width: 100%;
    height: 300px;
    /* Fixed height for consistency */
    object-fit: cover;
    display: block;
    transition: transform 0.3s ease;
  }

  .image-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: rgba(0, 0, 0, 0.2);
    transition: background 0.3s ease;
  }

  .image-content {
    position: absolute;
    bottom: 0;
    left: 0;
    right: 0;
    padding: 20px;
    color: white;
  }

  .image-card:hover img {
    transform: scale(1.05);
  }

  .image-card:hover .image-overlay {
    background: rgba(0, 0, 0, 0.7);
  }

  .image-title {
    font-weight: 600;
    font-size: 1.25rem;
    margin-bottom: 0.5rem;
  }

  .image-description {
    margin-bottom: 0;
  }

  .bg-gold {
    background-color: #a06b04;
  }

  .btn-navy {
    background-color: #2C3E50;
    color: #F1C40F;
    font-weight: 600;
    padding: 12px 30px;
    border-radius: 0;
  }

  .text-navy {
    color: #fff;
  }

  .text-gold {
    color: #F1C40F;
  }

  .bg-navy {
    background-color: #f5f6f8;
  }
</style>

<section id="" class="bg-navy py-5">
  <div class="container">

    <div class="row mb-5 align-items-end">
      <div class="col-lg-6 mb-3 mb-lg-0">
        <h6 class="text-uppercase">Our Products</h6>
        <h2 class="fw-bold">Our uPVC are made from <br />Quality Accessories.</h2>
      </div>
      <div class="col-lg-6">
        <p class="lead">At Y&W all our products meet European standard and have a long life span.</p>
      </div>
    </div>

    <div class="row">
    <?php foreach ($viewContent as $content): ?>
          <?php $link = $this->Url->build([
          'controller' => $this->request->getParam('subsection') ?: ($this->request->getParam('section') ?: $this->request->getParam('controller')),
          'action' => 'details',
          $content->id
        ]) ?>

        <div class="col-md-4">
          <a href="<?= $this->Url->build(['controller' => $menuDetails->slug, 'action' => 'details', $content->id]) ?>">
          <div class="image-card">
          <img
                src="<?= $this->Url->image(!empty($content->content_images) && !empty($content->content_images[0]->image_path) ? $content->content_images[0]->image_path : 'noimage.png') ?>"
                class="img-fluid w-100 rounded-3" alt="<?= h($content->name) ?>" />

            <div class="image-overlay"></div>
            <div class="image-content">
              <h3 class="image-title"><?= $content->name?></h3>
              <!-- <p class="image-description"><//?= $content->content?></p> -->
            </div>
          </div>
          </a>
        </div>
        <?php endforeach ?>

    </div>

  </div>
</section>

<section class="py-5 bg-gold">
  <div class="container py-5">
    <div class="row align-items-center">
      <div class="col-lg-8 text-center text-lg-start">
        <h1 class="fw-bold mb-3 text-navy">Ready to Upgrade Your Property?</h1>
        <p class="lead mb-0 text-navy">Get in touch with our experts today.</p>
      </div>
      <div class="col-lg-4 text-center text-lg-end mt-4 mt-lg-0">
        <a href="#contact" class="btn btn-light btn-lg">Contact Us Now <i class="bi bi-telephone-fill ms-2"></i></a>
      </div>
    </div>
  </div>
</section>