<?php
/**
 * CakePHP(tm) : Rapid Development Framework (https://cakephp.org)
 * Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 *
 * Licensed under The MIT License
 * For full copyright and license information, please see the LICENSE.txt
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright (c) Cake Software Foundation, Inc. (https://cakefoundation.org)
 * @link          https://cakephp.org CakePHP(tm) Project
 * @since         0.10.0
 * @license       https://opensource.org/licenses/mit-license.php MIT License
 * @var \App\View\AppView $this
 */

$siteDescription = $appSettings['SITE-NAME'];

?>
<!DOCTYPE html>
<html>

<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>
        <?= $siteDescription ?>:
        <?= $this->fetch('title') ?>
    </title>

   <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@700&family=Cormorant+Garamond:wght@500&family=Montserrat:wght@400;500&display=swap" rel="stylesheet">

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/odometer.js/0.4.8/themes/odometer-theme-default.min.css">

    <?= $this->Html->meta('icon') ?>

    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
</head>

<!-- Start of the HTML body section -->

<body>

    <!-- Navigation bar section for top-level site navigation -->
    <nav>
        <?php echo $this->element(Cake\Core\Configure::read('Menus.main_menu', 'menus/default_menu')); ?>
    </nav>

    <!-- Main content container for the page -->
    <main class="main">
        <!-- Fetches and renders the content from the view or layout in CakePHP -->
        <!-- $this->fetch('content') retrieves the main content block defined in the view -->
        <?= $this->fetch('content') ?>
    </main>

    <!-- Footer section for site-wide footer content -->
    <footer>
        <!-- Placeholder for footer content such as copyright, links, or contact info -->
        <?php echo $this->element(Cake\Core\Configure::read('Footers.footer', 'footers/default_footer')); ?>
    </footer>

</body>
<!-- End of the HTML body section -->
<?= $this->fetch('script') ?>
<!-- Include Odometer JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/odometer.js/0.4.8/odometer.min.js"></script>
<script>
  // Function to start the animation
  function startOdometer() {
    document.getElementById('stat1').innerHTML = 100;
    document.getElementById('stat2').innerHTML = 500;
    document.getElementById('stat3').innerHTML = 24;
    document.getElementById('stat4').innerHTML = 10;
  }

  // Set up Intersection Observer to trigger when the section is in view
  const observer = new IntersectionObserver((entries, observer) => {
    entries.forEach(entry => {
      if (entry.isIntersecting) {
        startOdometer(); // Start the odometer animation
        observer.disconnect(); // Stop observing after the animation starts
      }
    });
  }, {
    threshold: 0.5 // Trigger when 50% of the section is visible
  });

  // Start observing the stats section
  observer.observe(document.getElementById('stats-section'));
</script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        AOS.init({
            once: false, // Animations only happen once
            //   easing: 'ease-in-out',
            offset: 120,
            duration: 800
        });
    });
</script>

</html>